﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TranslationStatus.aspx.cs" Inherits="Smartling.Connector.Shell.TranslationStatus" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Translation Progress</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
    <link href="/sitecore modules/shell/Smartling.Connector/css/bootstrap-multiselect.css" rel="stylesheet" />
    <link href="/sitecore modules/shell/Smartling.Connector/css/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="/sitecore modules/shell/Smartling.Connector/css/dataTables.checkboxes.css" rel="stylesheet" />
    <link href="/sitecore modules/shell/Smartling.Connector/css/smartling.css" rel="stylesheet" />
</head>
<body>
    <div>
        <div class="form-horizontal header">
            <div class="download">
                <button type="button" id="download" class="btn btn-primary" disabled="disabled">Download <span id="progress" style="display: none;" class="glyphicon glyphicon-refresh glyphicon-refresh-animate"></span></button>
                <span id="message"></span>
            </div>

            <div class="contentFilter">
                <button type="button" id="search" class="btn btn-success">Search</button>&nbsp;
            </div>

            <div class="contentFilter">
                <input class="form-control" id="path" placeholder="Enter keywords" type="text">
            </div>

            <div class="contentFilter">
                <select id="languages" name="targetLanguage[]" multiple="multiple">
                    <asp:Literal ID="LanguageOptions" runat="server"></asp:Literal>
                </select>&nbsp;
            </div>
            
            <div class="contentFilter">
                <select id="submitters" name="submitter[]" multiple="multiple">
                    <asp:Literal ID="Submitters" runat="server"></asp:Literal>
                </select>&nbsp;
            </div>

            <div class="contentFilter">
                <select id="statuses" name="translationStatus[]" multiple="multiple">
                    <option value="Waiting">New</option>
                    <option value="Pushed">In Progress</option>
                    <option value="Failed">Failed</option>
                    <option value="Pulled">Completed</option>
                </select>&nbsp;
            </div>

            <div class="contentFilter">
                <select id="contentType" name="translationStatus[]" multiple="multiple">
                    <option value="Content">Content</option>
                    <option value="Media File">Media File</option>
                </select>&nbsp;
            </div>
        </div>
        <table id="items" class="table table-hover" style="width: 100%;">
            <thead>
                <tr>
                    <th></th>
                    <th>Path</th>
                    <th>Source</th>
                    <th>Target</th>
                    <th>Status</th>
                    <th>ContentType</th>
                    <th>Complete</th>
                    <th>Submitter</th>
                    <th>WordCount</th>
                    <th>Submitted</th>
                    <th>Downloaded</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>

    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/jquery.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/dataTables.checkboxes.js"></script>
    <script type="text/javascript" src="/sitecore modules/shell/Smartling.Connector/js/bootstrap-multiselect.js"></script>
    <script type="text/javascript">
        function UpdateDownloadButtonState(table) {
            var rows_selected = table.column(0).checkboxes.selected();
            if (rows_selected.length === 0) {
                $("#download").prop("disabled", true);
            } else {
                $("#download").prop("disabled", false);
            }
        }

        $(document).ready(function () {
            $('#statuses').multiselect({
                includeSelectAllOption: true,
                nonSelectedText: 'Status',
                onChange: function () {
                    table.ajax.reload();
                }
            });

            $('#languages').multiselect({
                includeSelectAllOption: true,
                nonSelectedText: 'Language',
                onChange: function () {
                    table.ajax.reload();
                }
            });

            $('#submitters').multiselect({
                includeSelectAllOption: true,
                nonSelectedText: 'Submitter',
                onChange: function () {
                    table.ajax.reload();
                }
            });

            $('#contentType').multiselect({
                includeSelectAllOption: true,
                nonSelectedText: 'Type',
                onChange: function () {
                    table.ajax.reload();
                }
            });

            var table = $('#items').DataTable({
                "ajax": {
                    "url": '/sitecore%20modules/shell/Smartling.Connector/Items.ashx'
                    ,
                    "data": function (d) {
                        return {
                            "path": $('#path').val(),
                            "languages": $('#languages').val(),
                            "submitters": $('#submitters').val(),
                            "statuses": $('#statuses').val(),
                            "contentType": $('#contentType').val(),
                            "draw": d.draw,
                            "start": d.start,
                            "length": d.length,
                            "orderby": d.order[0].column,
                            "orderdir": d.order[0].dir
                        };
                    }
                },
                "dom": "<'row'<'col-sm-6'><'col-sm-6'f>>" +
                       "<'row'<'col-sm-12'tr>>" +
                       "<'row'<'col-sm-5'li><'col-sm-7'p>>",
                "paging": true,
                "processing": true,
                "serverSide": true,
                "searching": false,
                "ordering": true,
                "order": [[ 1, "desc" ]],
                'columnDefs': [
                    {
                        'targets': 0,
                        'checkboxes': {
                            'selectRow': true
                        }
                    },
                    { className: "dt-right", "targets": [5, 7] },
                    { orderable: true, "targets": [1, 9, 10] },
                    { orderable: false, "targets": "_all" }
            ],
                'select': {
                    'style': 'multi'
                }
            });

            $("#search").click(function () {
                table.ajax.reload();
            });

            $("#download").click(function () {
                var rows_selected = table.column(0).checkboxes.selected();
                var ids = "";
                $.each(rows_selected, function (index, rowId) {
                    ids += rowId + ",";
                });

                if (ids !== "") {
                    table.column(0).checkboxes.deselect();
                    UpdateDownloadButtonState(table);

                    $("#progress").show();
                    $("#message").empty();

                    $.ajax({
                        url: "/sitecore%20modules/shell/Smartling.Connector/DownloadTranslation.ashx?items=" + ids,
                        type: 'GET',
                        success: function () {
                            $("#progress").hide();
                            $("#message").append('<div class="alert alert-success fade in"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Items have been downloaded successfully.</div>');
                        },
                        error: function () {
                            $("#progress").hide();
                            $("#message").append('<div class="alert alert-danger fade in"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>An error has occured, please check the log files.</div>');
                        }
                    });
                }
            });

            $('#items').on('change', 'input[type="checkbox"]', function (e) {
                UpdateDownloadButtonState(table);
            });

            $('#items tbody').on('click', 'tr', function () {
                UpdateDownloadButtonState(table);
            });

            $('input').keypress(function (e) {
                if (e.which == 13) {
                    table.ajax.reload();
                    return false;
                }
            });
        });
    </script>
</body>
</html>
